<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDevicesRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getDevicesRequestImpl
 * @subpackage Structs
 */
class GetDevicesRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The deviceType
     * @var string
     */
    public $deviceType;
    /**
     * The deviceStatusType
     * @var string
     */
    public $deviceStatusType;
    /**
     * The submarketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarketId;
    /**
     * The numResults
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $numResults;
    /**
     * The ip
     * @var \StructType\DeviceIpSearchParametersImpl
     */
    public $ip;
    /**
     * The num
     * @var \StructType\DeviceNumSearchParametersImpl
     */
    public $num;
    /**
     * Constructor method for getDevicesRequestImpl
     * @uses GetDevicesRequestImpl::setServiceType()
     * @uses GetDevicesRequestImpl::setDeviceType()
     * @uses GetDevicesRequestImpl::setDeviceStatusType()
     * @uses GetDevicesRequestImpl::setSubmarketId()
     * @uses GetDevicesRequestImpl::setNumResults()
     * @uses GetDevicesRequestImpl::setIp()
     * @uses GetDevicesRequestImpl::setNum()
     * @param string $serviceType
     * @param string $deviceType
     * @param string $deviceStatusType
     * @param string $submarketId
     * @param int $numResults
     * @param \StructType\DeviceIpSearchParametersImpl $ip
     * @param \StructType\DeviceNumSearchParametersImpl $num
     */
    public function __construct($serviceType = null, $deviceType = null, $deviceStatusType = null, $submarketId = null, $numResults = 0, \StructType\DeviceIpSearchParametersImpl $ip = null, \StructType\DeviceNumSearchParametersImpl $num = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setDeviceType($deviceType)
            ->setDeviceStatusType($deviceStatusType)
            ->setSubmarketId($submarketId)
            ->setNumResults($numResults)
            ->setIp($ip)
            ->setNum($num);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get deviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->deviceType;
    }
    /**
     * Set deviceType value
     * @uses \EnumType\DeviceTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceType, implode(', ', \EnumType\DeviceTypeEnum::getValidValues())), __LINE__);
        }
        $this->deviceType = $deviceType;
        return $this;
    }
    /**
     * Get deviceStatusType value
     * @return string|null
     */
    public function getDeviceStatusType()
    {
        return $this->deviceStatusType;
    }
    /**
     * Set deviceStatusType value
     * @uses \EnumType\DeviceStatusTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceStatusTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceStatusType
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setDeviceStatusType($deviceStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceStatusTypeEnum::valueIsValid($deviceStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceStatusType, implode(', ', \EnumType\DeviceStatusTypeEnum::getValidValues())), __LINE__);
        }
        $this->deviceStatusType = $deviceStatusType;
        return $this;
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get numResults value
     * @return int|null
     */
    public function getNumResults()
    {
        return $this->numResults;
    }
    /**
     * Set numResults value
     * @param int $numResults
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setNumResults($numResults = 0)
    {
        // validation for constraint: int
        if (!is_null($numResults) && !is_numeric($numResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numResults)), __LINE__);
        }
        $this->numResults = $numResults;
        return $this;
    }
    /**
     * Get ip value
     * @return \StructType\DeviceIpSearchParametersImpl|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @param \StructType\DeviceIpSearchParametersImpl $ip
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setIp(\StructType\DeviceIpSearchParametersImpl $ip = null)
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Get num value
     * @return \StructType\DeviceNumSearchParametersImpl|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param \StructType\DeviceNumSearchParametersImpl $num
     * @return \StructType\GetDevicesRequestImpl
     */
    public function setNum(\StructType\DeviceNumSearchParametersImpl $num = null)
    {
        $this->num = $num;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDevicesRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
