<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDemoAndTrialCountsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getDemoAndTrialCountsRequestImpl
 * @subpackage Structs
 */
class GetDemoAndTrialCountsRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for getDemoAndTrialCountsRequestImpl
     * @uses GetDemoAndTrialCountsRequestImpl::setServiceType()
     * @param string $serviceType
     */
    public function __construct($serviceType = null)
    {
        $this
            ->setServiceType($serviceType);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetDemoAndTrialCountsRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDemoAndTrialCountsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
