<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAccountPoolingGroupsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getAccountPoolingGroupsRequestImpl
 * @subpackage Structs
 */
class GetAccountPoolingGroupsRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The submarket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarket;
    /**
     * The poolGroupType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $poolGroupType;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - default: ACTIVE
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for getAccountPoolingGroupsRequestImpl
     * @uses GetAccountPoolingGroupsRequestImpl::setServiceType()
     * @uses GetAccountPoolingGroupsRequestImpl::setSubmarket()
     * @uses GetAccountPoolingGroupsRequestImpl::setPoolGroupType()
     * @uses GetAccountPoolingGroupsRequestImpl::setStatus()
     * @param string $serviceType
     * @param string $submarket
     * @param string $poolGroupType
     * @param string $status
     */
    public function __construct($serviceType = null, $submarket = null, $poolGroupType = null, $status = 'ACTIVE')
    {
        $this
            ->setServiceType($serviceType)
            ->setSubmarket($submarket)
            ->setPoolGroupType($poolGroupType)
            ->setStatus($status);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetAccountPoolingGroupsRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get submarket value
     * @return string|null
     */
    public function getSubmarket()
    {
        return $this->submarket;
    }
    /**
     * Set submarket value
     * @param string $submarket
     * @return \StructType\GetAccountPoolingGroupsRequestImpl
     */
    public function setSubmarket($submarket = null)
    {
        // validation for constraint: string
        if (!is_null($submarket) && !is_string($submarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarket)), __LINE__);
        }
        $this->submarket = $submarket;
        return $this;
    }
    /**
     * Get poolGroupType value
     * @return string|null
     */
    public function getPoolGroupType()
    {
        return $this->poolGroupType;
    }
    /**
     * Set poolGroupType value
     * @uses \EnumType\PoolGroupTypeEnum::valueIsValid()
     * @uses \EnumType\PoolGroupTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $poolGroupType
     * @return \StructType\GetAccountPoolingGroupsRequestImpl
     */
    public function setPoolGroupType($poolGroupType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PoolGroupTypeEnum::valueIsValid($poolGroupType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $poolGroupType, implode(', ', \EnumType\PoolGroupTypeEnum::getValidValues())), __LINE__);
        }
        $this->poolGroupType = $poolGroupType;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusEnum::valueIsValid()
     * @uses \EnumType\StatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\GetAccountPoolingGroupsRequestImpl
     */
    public function setStatus($status = 'ACTIVE')
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountPoolingGroupsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
