<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAccountPoolingGroupRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getAccountPoolingGroupRequestImpl
 * @subpackage Structs
 */
class GetAccountPoolingGroupRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The poolId
     * @var string
     */
    public $poolId;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for getAccountPoolingGroupRequestImpl
     * @uses GetAccountPoolingGroupRequestImpl::setPoolId()
     * @uses GetAccountPoolingGroupRequestImpl::setLimit()
     * @uses GetAccountPoolingGroupRequestImpl::setStartRow()
     * @param string $poolId
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($poolId = null, $limit = null, $startRow = null)
    {
        $this
            ->setPoolId($poolId)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get poolId value
     * @return string|null
     */
    public function getPoolId()
    {
        return $this->poolId;
    }
    /**
     * Set poolId value
     * @param string $poolId
     * @return \StructType\GetAccountPoolingGroupRequestImpl
     */
    public function setPoolId($poolId = null)
    {
        // validation for constraint: string
        if (!is_null($poolId) && !is_string($poolId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($poolId)), __LINE__);
        }
        $this->poolId = $poolId;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetAccountPoolingGroupRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\GetAccountPoolingGroupRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountPoolingGroupRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
