<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for devices StructType
 * @subpackage Structs
 */
class Devices extends AbstractStructBase
{
    /**
     * The device
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $device;
    /**
     * The vpn
     * @var \StructType\DeviceApnImpl
     */
    public $vpn;
    /**
     * The sim
     * @var \StructType\DeviceSimImpl
     */
    public $sim;
    /**
     * The num
     * @var \StructType\DeviceNumberImpl
     */
    public $num;
    /**
     * The ip
     * @var \StructType\DeviceIpImpl
     */
    public $ip;
    /**
     * The capcode
     * @var \StructType\DeviceCapcodeImpl
     */
    public $capcode;
    /**
     * Constructor method for devices
     * @uses Devices::setDevice()
     * @uses Devices::setVpn()
     * @uses Devices::setSim()
     * @uses Devices::setNum()
     * @uses Devices::setIp()
     * @uses Devices::setCapcode()
     * @param string[] $device
     * @param \StructType\DeviceApnImpl $vpn
     * @param \StructType\DeviceSimImpl $sim
     * @param \StructType\DeviceNumberImpl $num
     * @param \StructType\DeviceIpImpl $ip
     * @param \StructType\DeviceCapcodeImpl $capcode
     */
    public function __construct(array $device = array(), \StructType\DeviceApnImpl $vpn = null, \StructType\DeviceSimImpl $sim = null, \StructType\DeviceNumberImpl $num = null, \StructType\DeviceIpImpl $ip = null, \StructType\DeviceCapcodeImpl $capcode = null)
    {
        $this
            ->setDevice($device)
            ->setVpn($vpn)
            ->setSim($sim)
            ->setNum($num)
            ->setIp($ip)
            ->setCapcode($capcode);
    }
    /**
     * Get device value
     * @return string[]|null
     */
    public function getDevice()
    {
        return $this->device;
    }
    /**
     * Set device value
     * @throws \InvalidArgumentException
     * @param string[] $device
     * @return \StructType\Devices
     */
    public function setDevice(array $device = array())
    {
        foreach ($device as $devicesDeviceItem) {
            // validation for constraint: itemType
            if (!is_string($devicesDeviceItem)) {
                throw new \InvalidArgumentException(sprintf('The device property can only contain items of string, "%s" given', is_object($devicesDeviceItem) ? get_class($devicesDeviceItem) : gettype($devicesDeviceItem)), __LINE__);
            }
        }
        $this->device = $device;
        return $this;
    }
    /**
     * Add item to device value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Devices
     */
    public function addToDevice($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The device property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->device[] = $item;
        return $this;
    }
    /**
     * Get vpn value
     * @return \StructType\DeviceApnImpl|null
     */
    public function getVpn()
    {
        return $this->vpn;
    }
    /**
     * Set vpn value
     * @param \StructType\DeviceApnImpl $vpn
     * @return \StructType\Devices
     */
    public function setVpn(\StructType\DeviceApnImpl $vpn = null)
    {
        $this->vpn = $vpn;
        return $this;
    }
    /**
     * Get sim value
     * @return \StructType\DeviceSimImpl|null
     */
    public function getSim()
    {
        return $this->sim;
    }
    /**
     * Set sim value
     * @param \StructType\DeviceSimImpl $sim
     * @return \StructType\Devices
     */
    public function setSim(\StructType\DeviceSimImpl $sim = null)
    {
        $this->sim = $sim;
        return $this;
    }
    /**
     * Get num value
     * @return \StructType\DeviceNumberImpl|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param \StructType\DeviceNumberImpl $num
     * @return \StructType\Devices
     */
    public function setNum(\StructType\DeviceNumberImpl $num = null)
    {
        $this->num = $num;
        return $this;
    }
    /**
     * Get ip value
     * @return \StructType\DeviceIpImpl|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @param \StructType\DeviceIpImpl $ip
     * @return \StructType\Devices
     */
    public function setIp(\StructType\DeviceIpImpl $ip = null)
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Get capcode value
     * @return \StructType\DeviceCapcodeImpl|null
     */
    public function getCapcode()
    {
        return $this->capcode;
    }
    /**
     * Set capcode value
     * @param \StructType\DeviceCapcodeImpl $capcode
     * @return \StructType\Devices
     */
    public function setCapcode(\StructType\DeviceCapcodeImpl $capcode = null)
    {
        $this->capcode = $capcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Devices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
