<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deviceNumSearchParametersImpl StructType
 * @subpackage Structs
 */
class DeviceNumSearchParametersImpl extends AbstractStructBase
{
    /**
     * The numberType
     * @var string
     */
    public $numberType;
    /**
     * The networkElement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $networkElement;
    /**
     * Constructor method for deviceNumSearchParametersImpl
     * @uses DeviceNumSearchParametersImpl::setNumberType()
     * @uses DeviceNumSearchParametersImpl::setNetworkElement()
     * @param string $numberType
     * @param string $networkElement
     */
    public function __construct($numberType = null, $networkElement = null)
    {
        $this
            ->setNumberType($numberType)
            ->setNetworkElement($networkElement);
    }
    /**
     * Get numberType value
     * @return string|null
     */
    public function getNumberType()
    {
        return $this->numberType;
    }
    /**
     * Set numberType value
     * @uses \EnumType\DeviceNumberTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceNumberTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberType
     * @return \StructType\DeviceNumSearchParametersImpl
     */
    public function setNumberType($numberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceNumberTypeEnum::valueIsValid($numberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberType, implode(', ', \EnumType\DeviceNumberTypeEnum::getValidValues())), __LINE__);
        }
        $this->numberType = $numberType;
        return $this;
    }
    /**
     * Get networkElement value
     * @return string|null
     */
    public function getNetworkElement()
    {
        return $this->networkElement;
    }
    /**
     * Set networkElement value
     * @param string $networkElement
     * @return \StructType\DeviceNumSearchParametersImpl
     */
    public function setNetworkElement($networkElement = null)
    {
        // validation for constraint: string
        if (!is_null($networkElement) && !is_string($networkElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($networkElement)), __LINE__);
        }
        $this->networkElement = $networkElement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeviceNumSearchParametersImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
