<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryDestinationSearchAndReplaceRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deliveryDestinationSearchAndReplaceRequestImpl
 * @subpackage Structs
 */
class DeliveryDestinationSearchAndReplaceRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The oldValue
     * @var string
     */
    public $oldValue;
    /**
     * The newValue
     * @var string
     */
    public $newValue;
    /**
     * The searchOnlyFlag
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $searchOnlyFlag;
    /**
     * The includeSuspended
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $includeSuspended;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for deliveryDestinationSearchAndReplaceRequestImpl
     * @uses DeliveryDestinationSearchAndReplaceRequestImpl::setOldValue()
     * @uses DeliveryDestinationSearchAndReplaceRequestImpl::setNewValue()
     * @uses DeliveryDestinationSearchAndReplaceRequestImpl::setSearchOnlyFlag()
     * @uses DeliveryDestinationSearchAndReplaceRequestImpl::setIncludeSuspended()
     * @uses DeliveryDestinationSearchAndReplaceRequestImpl::setServiceType()
     * @param string $oldValue
     * @param string $newValue
     * @param bool $searchOnlyFlag
     * @param bool $includeSuspended
     * @param string $serviceType
     */
    public function __construct($oldValue = null, $newValue = null, $searchOnlyFlag = true, $includeSuspended = false, $serviceType = null)
    {
        $this
            ->setOldValue($oldValue)
            ->setNewValue($newValue)
            ->setSearchOnlyFlag($searchOnlyFlag)
            ->setIncludeSuspended($includeSuspended)
            ->setServiceType($serviceType);
    }
    /**
     * Get oldValue value
     * @return string|null
     */
    public function getOldValue()
    {
        return $this->oldValue;
    }
    /**
     * Set oldValue value
     * @param string $oldValue
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldValue)), __LINE__);
        }
        $this->oldValue = $oldValue;
        return $this;
    }
    /**
     * Get newValue value
     * @return string|null
     */
    public function getNewValue()
    {
        return $this->newValue;
    }
    /**
     * Set newValue value
     * @param string $newValue
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newValue)), __LINE__);
        }
        $this->newValue = $newValue;
        return $this;
    }
    /**
     * Get searchOnlyFlag value
     * @return bool|null
     */
    public function getSearchOnlyFlag()
    {
        return $this->searchOnlyFlag;
    }
    /**
     * Set searchOnlyFlag value
     * @param bool $searchOnlyFlag
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public function setSearchOnlyFlag($searchOnlyFlag = true)
    {
        $this->searchOnlyFlag = $searchOnlyFlag;
        return $this;
    }
    /**
     * Get includeSuspended value
     * @return bool|null
     */
    public function getIncludeSuspended()
    {
        return $this->includeSuspended;
    }
    /**
     * Set includeSuspended value
     * @param bool $includeSuspended
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public function setIncludeSuspended($includeSuspended = false)
    {
        $this->includeSuspended = $includeSuspended;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDestinationSearchAndReplaceRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
