<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dataList StructType
 * @subpackage Structs
 */
class DataList extends AbstractStructBase
{
    /**
     * The dataEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CallDataEntryImpl[]
     */
    public $dataEntry;
    /**
     * Constructor method for dataList
     * @uses DataList::setDataEntry()
     * @param \StructType\CallDataEntryImpl[] $dataEntry
     */
    public function __construct(array $dataEntry = array())
    {
        $this
            ->setDataEntry($dataEntry);
    }
    /**
     * Get dataEntry value
     * @return \StructType\CallDataEntryImpl[]|null
     */
    public function getDataEntry()
    {
        return $this->dataEntry;
    }
    /**
     * Set dataEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\CallDataEntryImpl[] $dataEntry
     * @return \StructType\DataList
     */
    public function setDataEntry(array $dataEntry = array())
    {
        foreach ($dataEntry as $dataListDataEntryItem) {
            // validation for constraint: itemType
            if (!$dataListDataEntryItem instanceof \StructType\CallDataEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The dataEntry property can only contain items of \StructType\CallDataEntryImpl, "%s" given', is_object($dataListDataEntryItem) ? get_class($dataListDataEntryItem) : gettype($dataListDataEntryItem)), __LINE__);
            }
        }
        $this->dataEntry = $dataEntry;
        return $this;
    }
    /**
     * Add item to dataEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\CallDataEntryImpl $item
     * @return \StructType\DataList
     */
    public function addToDataEntry(\StructType\CallDataEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallDataEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The dataEntry property can only contain items of \StructType\CallDataEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dataEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
