<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for datCountImpl StructType
 * @subpackage Structs
 */
class DatCountImpl extends AbstractStructBase
{
    /**
     * The datType
     * @var string
     */
    public $datType;
    /**
     * The allowedCount
     * @var int
     */
    public $allowedCount;
    /**
     * The activeCount
     * @var int
     */
    public $activeCount;
    /**
     * Constructor method for datCountImpl
     * @uses DatCountImpl::setDatType()
     * @uses DatCountImpl::setAllowedCount()
     * @uses DatCountImpl::setActiveCount()
     * @param string $datType
     * @param int $allowedCount
     * @param int $activeCount
     */
    public function __construct($datType = null, $allowedCount = null, $activeCount = null)
    {
        $this
            ->setDatType($datType)
            ->setAllowedCount($allowedCount)
            ->setActiveCount($activeCount);
    }
    /**
     * Get datType value
     * @return string|null
     */
    public function getDatType()
    {
        return $this->datType;
    }
    /**
     * Set datType value
     * @uses \EnumType\DatTypeEnum::valueIsValid()
     * @uses \EnumType\DatTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datType
     * @return \StructType\DatCountImpl
     */
    public function setDatType($datType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatTypeEnum::valueIsValid($datType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $datType, implode(', ', \EnumType\DatTypeEnum::getValidValues())), __LINE__);
        }
        $this->datType = $datType;
        return $this;
    }
    /**
     * Get allowedCount value
     * @return int|null
     */
    public function getAllowedCount()
    {
        return $this->allowedCount;
    }
    /**
     * Set allowedCount value
     * @param int $allowedCount
     * @return \StructType\DatCountImpl
     */
    public function setAllowedCount($allowedCount = null)
    {
        // validation for constraint: int
        if (!is_null($allowedCount) && !is_numeric($allowedCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allowedCount)), __LINE__);
        }
        $this->allowedCount = $allowedCount;
        return $this;
    }
    /**
     * Get activeCount value
     * @return int|null
     */
    public function getActiveCount()
    {
        return $this->activeCount;
    }
    /**
     * Set activeCount value
     * @param int $activeCount
     * @return \StructType\DatCountImpl
     */
    public function setActiveCount($activeCount = null)
    {
        // validation for constraint: int
        if (!is_null($activeCount) && !is_numeric($activeCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeCount)), __LINE__);
        }
        $this->activeCount = $activeCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatCountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
