<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for configList StructType
 * @subpackage Structs
 */
class ConfigList extends AbstractStructBase
{
    /**
     * The config
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpServiceConfigurationInfoImpl[]
     */
    public $config;
    /**
     * Constructor method for configList
     * @uses ConfigList::setConfig()
     * @param \StructType\SpServiceConfigurationInfoImpl[] $config
     */
    public function __construct(array $config = array())
    {
        $this
            ->setConfig($config);
    }
    /**
     * Get config value
     * @return \StructType\SpServiceConfigurationInfoImpl[]|null
     */
    public function getConfig()
    {
        return $this->config;
    }
    /**
     * Set config value
     * @throws \InvalidArgumentException
     * @param \StructType\SpServiceConfigurationInfoImpl[] $config
     * @return \StructType\ConfigList
     */
    public function setConfig(array $config = array())
    {
        foreach ($config as $configListConfigItem) {
            // validation for constraint: itemType
            if (!$configListConfigItem instanceof \StructType\SpServiceConfigurationInfoImpl) {
                throw new \InvalidArgumentException(sprintf('The config property can only contain items of \StructType\SpServiceConfigurationInfoImpl, "%s" given', is_object($configListConfigItem) ? get_class($configListConfigItem) : gettype($configListConfigItem)), __LINE__);
            }
        }
        $this->config = $config;
        return $this;
    }
    /**
     * Add item to config value
     * @throws \InvalidArgumentException
     * @param \StructType\SpServiceConfigurationInfoImpl $item
     * @return \StructType\ConfigList
     */
    public function addToConfig(\StructType\SpServiceConfigurationInfoImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpServiceConfigurationInfoImpl) {
            throw new \InvalidArgumentException(sprintf('The config property can only contain items of \StructType\SpServiceConfigurationInfoImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->config[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConfigList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
