<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for changeUserProfileStatusRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:changeUserProfileStatusRequestImpl
 * @subpackage Structs
 */
class ChangeUserProfileStatusRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for changeUserProfileStatusRequestImpl
     * @uses ChangeUserProfileStatusRequestImpl::setUsername()
     * @uses ChangeUserProfileStatusRequestImpl::setStatus()
     * @param string $username
     * @param string $status
     */
    public function __construct($username = null, $status = null)
    {
        $this
            ->setUsername($username)
            ->setStatus($status);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ChangeUserProfileStatusRequestImpl
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusEnum::valueIsValid()
     * @uses \EnumType\StatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ChangeUserProfileStatusRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChangeUserProfileStatusRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
