<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certusStreamingImpl StructType
 * @subpackage Structs
 */
class CertusStreamingImpl extends AbsMemberServiceImpl
{
    /**
     * The streamingSpeed
     * @var string
     */
    public $streamingSpeed;
    /**
     * Constructor method for certusStreamingImpl
     * @uses CertusStreamingImpl::setStreamingSpeed()
     * @param string $streamingSpeed
     */
    public function __construct($streamingSpeed = null)
    {
        $this
            ->setStreamingSpeed($streamingSpeed);
    }
    /**
     * Get streamingSpeed value
     * @return string|null
     */
    public function getStreamingSpeed()
    {
        return $this->streamingSpeed;
    }
    /**
     * Set streamingSpeed value
     * @uses \EnumType\StreamingSpeedEnum::valueIsValid()
     * @uses \EnumType\StreamingSpeedEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $streamingSpeed
     * @return \StructType\CertusStreamingImpl
     */
    public function setStreamingSpeed($streamingSpeed = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StreamingSpeedEnum::valueIsValid($streamingSpeed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $streamingSpeed, implode(', ', \EnumType\StreamingSpeedEnum::getValidValues())), __LINE__);
        }
        $this->streamingSpeed = $streamingSpeed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertusStreamingImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
