<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callSummaryReportImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:callSummaryReportImpl
 * @subpackage Structs
 */
class CallSummaryReportImpl extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The imei
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imei;
    /**
     * The iccid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iccid;
    /**
     * The imsi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imsi;
    /**
     * The msisdn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $msisdn;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The usageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageType;
    /**
     * The usage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $usage;
    /**
     * The usageUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageUnit;
    /**
     * The totalAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $totalAmount;
    /**
     * The billMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $billMonth;
    /**
     * The planName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $planName;
    /**
     * Constructor method for callSummaryReportImpl
     * @uses CallSummaryReportImpl::setAccountNumber()
     * @uses CallSummaryReportImpl::setImei()
     * @uses CallSummaryReportImpl::setIccid()
     * @uses CallSummaryReportImpl::setImsi()
     * @uses CallSummaryReportImpl::setMsisdn()
     * @uses CallSummaryReportImpl::setServiceType()
     * @uses CallSummaryReportImpl::setUsageType()
     * @uses CallSummaryReportImpl::setUsage()
     * @uses CallSummaryReportImpl::setUsageUnit()
     * @uses CallSummaryReportImpl::setTotalAmount()
     * @uses CallSummaryReportImpl::setBillMonth()
     * @uses CallSummaryReportImpl::setPlanName()
     * @param string $accountNumber
     * @param string $imei
     * @param string $iccid
     * @param string $imsi
     * @param string $msisdn
     * @param string $serviceType
     * @param string $usageType
     * @param int $usage
     * @param string $usageUnit
     * @param string $totalAmount
     * @param string $billMonth
     * @param string $planName
     */
    public function __construct($accountNumber = null, $imei = null, $iccid = null, $imsi = null, $msisdn = null, $serviceType = null, $usageType = null, $usage = null, $usageUnit = null, $totalAmount = null, $billMonth = null, $planName = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setImei($imei)
            ->setIccid($iccid)
            ->setImsi($imsi)
            ->setMsisdn($msisdn)
            ->setServiceType($serviceType)
            ->setUsageType($usageType)
            ->setUsage($usage)
            ->setUsageUnit($usageUnit)
            ->setTotalAmount($totalAmount)
            ->setBillMonth($billMonth)
            ->setPlanName($planName);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\CallSummaryReportImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\CallSummaryReportImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get iccid value
     * @return string|null
     */
    public function getIccid()
    {
        return $this->iccid;
    }
    /**
     * Set iccid value
     * @param string $iccid
     * @return \StructType\CallSummaryReportImpl
     */
    public function setIccid($iccid = null)
    {
        // validation for constraint: string
        if (!is_null($iccid) && !is_string($iccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iccid)), __LINE__);
        }
        $this->iccid = $iccid;
        return $this;
    }
    /**
     * Get imsi value
     * @return string|null
     */
    public function getImsi()
    {
        return $this->imsi;
    }
    /**
     * Set imsi value
     * @param string $imsi
     * @return \StructType\CallSummaryReportImpl
     */
    public function setImsi($imsi = null)
    {
        // validation for constraint: string
        if (!is_null($imsi) && !is_string($imsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imsi)), __LINE__);
        }
        $this->imsi = $imsi;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \StructType\CallSummaryReportImpl
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\CallSummaryReportImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get usageType value
     * @return string|null
     */
    public function getUsageType()
    {
        return $this->usageType;
    }
    /**
     * Set usageType value
     * @param string $usageType
     * @return \StructType\CallSummaryReportImpl
     */
    public function setUsageType($usageType = null)
    {
        // validation for constraint: string
        if (!is_null($usageType) && !is_string($usageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageType)), __LINE__);
        }
        $this->usageType = $usageType;
        return $this;
    }
    /**
     * Get usage value
     * @return int|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param int $usage
     * @return \StructType\CallSummaryReportImpl
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: int
        if (!is_null($usage) && !is_numeric($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usage)), __LINE__);
        }
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get usageUnit value
     * @return string|null
     */
    public function getUsageUnit()
    {
        return $this->usageUnit;
    }
    /**
     * Set usageUnit value
     * @param string $usageUnit
     * @return \StructType\CallSummaryReportImpl
     */
    public function setUsageUnit($usageUnit = null)
    {
        // validation for constraint: string
        if (!is_null($usageUnit) && !is_string($usageUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usageUnit)), __LINE__);
        }
        $this->usageUnit = $usageUnit;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param string $totalAmount
     * @return \StructType\CallSummaryReportImpl
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalAmount) && !is_string($totalAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get billMonth value
     * @return string|null
     */
    public function getBillMonth()
    {
        return $this->billMonth;
    }
    /**
     * Set billMonth value
     * @param string $billMonth
     * @return \StructType\CallSummaryReportImpl
     */
    public function setBillMonth($billMonth = null)
    {
        // validation for constraint: string
        if (!is_null($billMonth) && !is_string($billMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billMonth)), __LINE__);
        }
        $this->billMonth = $billMonth;
        return $this;
    }
    /**
     * Get planName value
     * @return string|null
     */
    public function getPlanName()
    {
        return $this->planName;
    }
    /**
     * Set planName value
     * @param string $planName
     * @return \StructType\CallSummaryReportImpl
     */
    public function setPlanName($planName = null)
    {
        // validation for constraint: string
        if (!is_null($planName) && !is_string($planName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planName)), __LINE__);
        }
        $this->planName = $planName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallSummaryReportImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
