<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for burstServiceSubscriberAccountImpl StructType
 * @subpackage Structs
 */
class BurstServiceSubscriberAccountImpl extends AbsSubscriberAccountImpl
{
    /**
     * The serviceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceName;
    /**
     * The plan
     * @var \StructType\BurstServiceSubAccountPlanImpl
     */
    public $plan;
    /**
     * The subscribers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Subscribers
     */
    public $subscribers;
    /**
     * Constructor method for burstServiceSubscriberAccountImpl
     * @uses BurstServiceSubscriberAccountImpl::setServiceName()
     * @uses BurstServiceSubscriberAccountImpl::setPlan()
     * @uses BurstServiceSubscriberAccountImpl::setSubscribers()
     * @param string $serviceName
     * @param \StructType\BurstServiceSubAccountPlanImpl $plan
     * @param \StructType\Subscribers $subscribers
     */
    public function __construct($serviceName = null, \StructType\BurstServiceSubAccountPlanImpl $plan = null, \StructType\Subscribers $subscribers = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setPlan($plan)
            ->setSubscribers($subscribers);
    }
    /**
     * Get serviceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \StructType\BurstServiceSubscriberAccountImpl
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceName)), __LINE__);
        }
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get plan value
     * @return \StructType\BurstServiceSubAccountPlanImpl|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param \StructType\BurstServiceSubAccountPlanImpl $plan
     * @return \StructType\BurstServiceSubscriberAccountImpl
     */
    public function setPlan(\StructType\BurstServiceSubAccountPlanImpl $plan = null)
    {
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get subscribers value
     * @return \StructType\Subscribers|null
     */
    public function getSubscribers()
    {
        return $this->subscribers;
    }
    /**
     * Set subscribers value
     * @param \StructType\Subscribers $subscribers
     * @return \StructType\BurstServiceSubscriberAccountImpl
     */
    public function setSubscribers(\StructType\Subscribers $subscribers = null)
    {
        $this->subscribers = $subscribers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BurstServiceSubscriberAccountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
