<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bulkActions StructType
 * @subpackage Structs
 */
class BulkActions extends AbstractStructBase
{
    /**
     * The bulkAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BulkActionEntryImpl[]
     */
    public $bulkAction;
    /**
     * Constructor method for bulkActions
     * @uses BulkActions::setBulkAction()
     * @param \StructType\BulkActionEntryImpl[] $bulkAction
     */
    public function __construct(array $bulkAction = array())
    {
        $this
            ->setBulkAction($bulkAction);
    }
    /**
     * Get bulkAction value
     * @return \StructType\BulkActionEntryImpl[]|null
     */
    public function getBulkAction()
    {
        return $this->bulkAction;
    }
    /**
     * Set bulkAction value
     * @throws \InvalidArgumentException
     * @param \StructType\BulkActionEntryImpl[] $bulkAction
     * @return \StructType\BulkActions
     */
    public function setBulkAction(array $bulkAction = array())
    {
        foreach ($bulkAction as $bulkActionsBulkActionItem) {
            // validation for constraint: itemType
            if (!$bulkActionsBulkActionItem instanceof \StructType\BulkActionEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The bulkAction property can only contain items of \StructType\BulkActionEntryImpl, "%s" given', is_object($bulkActionsBulkActionItem) ? get_class($bulkActionsBulkActionItem) : gettype($bulkActionsBulkActionItem)), __LINE__);
            }
        }
        $this->bulkAction = $bulkAction;
        return $this;
    }
    /**
     * Add item to bulkAction value
     * @throws \InvalidArgumentException
     * @param \StructType\BulkActionEntryImpl $item
     * @return \StructType\BulkActions
     */
    public function addToBulkAction(\StructType\BulkActionEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BulkActionEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The bulkAction property can only contain items of \StructType\BulkActionEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bulkAction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkActions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
