<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bcaList StructType
 * @subpackage Structs
 */
class BcaList extends AbstractStructBase
{
    /**
     * The bca
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $bca;
    /**
     * Constructor method for bcaList
     * @uses BcaList::setBca()
     * @param string[] $bca
     */
    public function __construct(array $bca = array())
    {
        $this
            ->setBca($bca);
    }
    /**
     * Get bca value
     * @return string[]|null
     */
    public function getBca()
    {
        return $this->bca;
    }
    /**
     * Set bca value
     * @throws \InvalidArgumentException
     * @param string[] $bca
     * @return \StructType\BcaList
     */
    public function setBca(array $bca = array())
    {
        foreach ($bca as $bcaListBcaItem) {
            // validation for constraint: itemType
            if (!is_string($bcaListBcaItem)) {
                throw new \InvalidArgumentException(sprintf('The bca property can only contain items of string, "%s" given', is_object($bcaListBcaItem) ? get_class($bcaListBcaItem) : gettype($bcaListBcaItem)), __LINE__);
            }
        }
        $this->bca = $bca;
        return $this;
    }
    /**
     * Add item to bca value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BcaList
     */
    public function addToBca($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The bca property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bca[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BcaList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
