<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationException StructType
 * Meta informations extracted from the WSDL
 * - type: tns:AuthorizationException
 * @subpackage Structs
 */
class AuthorizationException extends AbstractStructBase
{
    /**
     * The causedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $causedBy;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorCode;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for AuthorizationException
     * @uses AuthorizationException::setCausedBy()
     * @uses AuthorizationException::setErrorCode()
     * @uses AuthorizationException::setMessage()
     * @param string $causedBy
     * @param string $errorCode
     * @param string $message
     */
    public function __construct($causedBy = null, $errorCode = null, $message = null)
    {
        $this
            ->setCausedBy($causedBy)
            ->setErrorCode($errorCode)
            ->setMessage($message);
    }
    /**
     * Get causedBy value
     * @return string|null
     */
    public function getCausedBy()
    {
        return $this->causedBy;
    }
    /**
     * Set causedBy value
     * @param string $causedBy
     * @return \StructType\AuthorizationException
     */
    public function setCausedBy($causedBy = null)
    {
        // validation for constraint: string
        if (!is_null($causedBy) && !is_string($causedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($causedBy)), __LINE__);
        }
        $this->causedBy = $causedBy;
        return $this;
    }
    /**
     * Get errorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @uses \EnumType\ErrorCodeEnum::valueIsValid()
     * @uses \EnumType\ErrorCodeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\AuthorizationException
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ErrorCodeEnum::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorCode, implode(', ', \EnumType\ErrorCodeEnum::getValidValues())), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\AuthorizationException
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizationException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
