<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for atsInfoEntryImpl StructType
 * @subpackage Structs
 */
class AtsInfoEntryImpl extends AbstractStructBase
{
    /**
     * The icao
     * @var string
     */
    public $icao;
    /**
     * The airlineRegistration
     * @var string
     */
    public $airlineRegistration;
    /**
     * The channel
     * @var string
     */
    public $channel;
    /**
     * Constructor method for atsInfoEntryImpl
     * @uses AtsInfoEntryImpl::setIcao()
     * @uses AtsInfoEntryImpl::setAirlineRegistration()
     * @uses AtsInfoEntryImpl::setChannel()
     * @param string $icao
     * @param string $airlineRegistration
     * @param string $channel
     */
    public function __construct($icao = null, $airlineRegistration = null, $channel = null)
    {
        $this
            ->setIcao($icao)
            ->setAirlineRegistration($airlineRegistration)
            ->setChannel($channel);
    }
    /**
     * Get icao value
     * @return string|null
     */
    public function getIcao()
    {
        return $this->icao;
    }
    /**
     * Set icao value
     * @param string $icao
     * @return \StructType\AtsInfoEntryImpl
     */
    public function setIcao($icao = null)
    {
        // validation for constraint: string
        if (!is_null($icao) && !is_string($icao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icao)), __LINE__);
        }
        $this->icao = $icao;
        return $this;
    }
    /**
     * Get airlineRegistration value
     * @return string|null
     */
    public function getAirlineRegistration()
    {
        return $this->airlineRegistration;
    }
    /**
     * Set airlineRegistration value
     * @param string $airlineRegistration
     * @return \StructType\AtsInfoEntryImpl
     */
    public function setAirlineRegistration($airlineRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($airlineRegistration) && !is_string($airlineRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineRegistration)), __LINE__);
        }
        $this->airlineRegistration = $airlineRegistration;
        return $this;
    }
    /**
     * Get channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->channel;
    }
    /**
     * Set channel value
     * @uses \EnumType\AtsChannelTypeEnum::valueIsValid()
     * @uses \EnumType\AtsChannelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channel
     * @return \StructType\AtsInfoEntryImpl
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AtsChannelTypeEnum::valueIsValid($channel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channel, implode(', ', \EnumType\AtsChannelTypeEnum::getValidValues())), __LINE__);
        }
        $this->channel = $channel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AtsInfoEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
