<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for allAccessInfo StructType
 * @subpackage Structs
 */
class AllAccessInfo extends AbstractStructBase
{
    /**
     * The accessInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserAccessInfoImpl[]
     */
    public $accessInfo;
    /**
     * Constructor method for allAccessInfo
     * @uses AllAccessInfo::setAccessInfo()
     * @param \StructType\UserAccessInfoImpl[] $accessInfo
     */
    public function __construct(array $accessInfo = array())
    {
        $this
            ->setAccessInfo($accessInfo);
    }
    /**
     * Get accessInfo value
     * @return \StructType\UserAccessInfoImpl[]|null
     */
    public function getAccessInfo()
    {
        return $this->accessInfo;
    }
    /**
     * Set accessInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UserAccessInfoImpl[] $accessInfo
     * @return \StructType\AllAccessInfo
     */
    public function setAccessInfo(array $accessInfo = array())
    {
        foreach ($accessInfo as $allAccessInfoAccessInfoItem) {
            // validation for constraint: itemType
            if (!$allAccessInfoAccessInfoItem instanceof \StructType\UserAccessInfoImpl) {
                throw new \InvalidArgumentException(sprintf('The accessInfo property can only contain items of \StructType\UserAccessInfoImpl, "%s" given', is_object($allAccessInfoAccessInfoItem) ? get_class($allAccessInfoAccessInfoItem) : gettype($allAccessInfoAccessInfoItem)), __LINE__);
            }
        }
        $this->accessInfo = $accessInfo;
        return $this;
    }
    /**
     * Add item to accessInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UserAccessInfoImpl $item
     * @return \StructType\AllAccessInfo
     */
    public function addToAccessInfo(\StructType\UserAccessInfoImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserAccessInfoImpl) {
            throw new \InvalidArgumentException(sprintf('The accessInfo property can only contain items of \StructType\UserAccessInfoImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->accessInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllAccessInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
