<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for airlines StructType
 * @subpackage Structs
 */
class Airlines extends AbstractStructBase
{
    /**
     * The airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlinesEntryImpl[]
     */
    public $airline;
    /**
     * Constructor method for airlines
     * @uses Airlines::setAirline()
     * @param \StructType\AirlinesEntryImpl[] $airline
     */
    public function __construct(array $airline = array())
    {
        $this
            ->setAirline($airline);
    }
    /**
     * Get airline value
     * @return \StructType\AirlinesEntryImpl[]|null
     */
    public function getAirline()
    {
        return $this->airline;
    }
    /**
     * Set airline value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlinesEntryImpl[] $airline
     * @return \StructType\Airlines
     */
    public function setAirline(array $airline = array())
    {
        foreach ($airline as $airlinesAirlineItem) {
            // validation for constraint: itemType
            if (!$airlinesAirlineItem instanceof \StructType\AirlinesEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The airline property can only contain items of \StructType\AirlinesEntryImpl, "%s" given', is_object($airlinesAirlineItem) ? get_class($airlinesAirlineItem) : gettype($airlinesAirlineItem)), __LINE__);
            }
        }
        $this->airline = $airline;
        return $this;
    }
    /**
     * Add item to airline value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlinesEntryImpl $item
     * @return \StructType\Airlines
     */
    public function addToAirline(\StructType\AirlinesEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlinesEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The airline property can only contain items of \StructType\AirlinesEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->airline[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Airlines
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
