<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for activationList StructType
 * @subpackage Structs
 */
class ActivationList extends AbstractStructBase
{
    /**
     * The activationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ScratchCardActivationStatusImpl[]
     */
    public $activationStatus;
    /**
     * Constructor method for activationList
     * @uses ActivationList::setActivationStatus()
     * @param \StructType\ScratchCardActivationStatusImpl[] $activationStatus
     */
    public function __construct(array $activationStatus = array())
    {
        $this
            ->setActivationStatus($activationStatus);
    }
    /**
     * Get activationStatus value
     * @return \StructType\ScratchCardActivationStatusImpl[]|null
     */
    public function getActivationStatus()
    {
        return $this->activationStatus;
    }
    /**
     * Set activationStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\ScratchCardActivationStatusImpl[] $activationStatus
     * @return \StructType\ActivationList
     */
    public function setActivationStatus(array $activationStatus = array())
    {
        foreach ($activationStatus as $activationListActivationStatusItem) {
            // validation for constraint: itemType
            if (!$activationListActivationStatusItem instanceof \StructType\ScratchCardActivationStatusImpl) {
                throw new \InvalidArgumentException(sprintf('The activationStatus property can only contain items of \StructType\ScratchCardActivationStatusImpl, "%s" given', is_object($activationListActivationStatusItem) ? get_class($activationListActivationStatusItem) : gettype($activationListActivationStatusItem)), __LINE__);
            }
        }
        $this->activationStatus = $activationStatus;
        return $this;
    }
    /**
     * Add item to activationStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\ScratchCardActivationStatusImpl $item
     * @return \StructType\ActivationList
     */
    public function addToActivationStatus(\StructType\ScratchCardActivationStatusImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ScratchCardActivationStatusImpl) {
            throw new \InvalidArgumentException(sprintf('The activationStatus property can only contain items of \StructType\ScratchCardActivationStatusImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->activationStatus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivationList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
