<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for actionNotificationImpl StructType
 * @subpackage Structs
 */
class ActionNotificationImpl extends AbstractStructBase
{
    /**
     * The actionType
     * @var string
     */
    public $actionType;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The enabled
     * @var string
     */
    public $enabled;
    /**
     * Constructor method for actionNotificationImpl
     * @uses ActionNotificationImpl::setActionType()
     * @uses ActionNotificationImpl::setDescription()
     * @uses ActionNotificationImpl::setEnabled()
     * @param string $actionType
     * @param string $description
     * @param string $enabled
     */
    public function __construct($actionType = null, $description = null, $enabled = null)
    {
        $this
            ->setActionType($actionType)
            ->setDescription($description)
            ->setEnabled($enabled);
    }
    /**
     * Get actionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->actionType;
    }
    /**
     * Set actionType value
     * @uses \EnumType\EmailNotificationTypeEnum::valueIsValid()
     * @uses \EnumType\EmailNotificationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ActionNotificationImpl
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmailNotificationTypeEnum::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionType, implode(', ', \EnumType\EmailNotificationTypeEnum::getValidValues())), __LINE__);
        }
        $this->actionType = $actionType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ActionNotificationImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\ActionNotificationImpl
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActionNotificationImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
