<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountTransitionReportRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:accountTransitionReportRequestImpl
 * @subpackage Structs
 */
class AccountTransitionReportRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for accountTransitionReportRequestImpl
     * @uses AccountTransitionReportRequestImpl::setServiceType()
     * @uses AccountTransitionReportRequestImpl::setStartDate()
     * @uses AccountTransitionReportRequestImpl::setEndDate()
     * @uses AccountTransitionReportRequestImpl::setLimit()
     * @uses AccountTransitionReportRequestImpl::setStartRow()
     * @param string $serviceType
     * @param string $startDate
     * @param string $endDate
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($serviceType = null, $startDate = null, $endDate = null, $limit = null, $startRow = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountTransitionReportRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
