<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountStatusChangeRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:accountStatusChangeRequestImpl
 * @subpackage Structs
 */
class AccountStatusChangeRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The updateType
     * @var string
     */
    public $updateType;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The newStatus
     * @var string
     */
    public $newStatus;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for accountStatusChangeRequestImpl
     * @uses AccountStatusChangeRequestImpl::setServiceType()
     * @uses AccountStatusChangeRequestImpl::setUpdateType()
     * @uses AccountStatusChangeRequestImpl::setValue()
     * @uses AccountStatusChangeRequestImpl::setNewStatus()
     * @uses AccountStatusChangeRequestImpl::setReason()
     * @param string $serviceType
     * @param string $updateType
     * @param string $value
     * @param string $newStatus
     * @param string $reason
     */
    public function __construct($serviceType = null, $updateType = null, $value = null, $newStatus = null, $reason = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setUpdateType($updateType)
            ->setValue($value)
            ->setNewStatus($newStatus)
            ->setReason($reason);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get updateType value
     * @return string|null
     */
    public function getUpdateType()
    {
        return $this->updateType;
    }
    /**
     * Set updateType value
     * @uses \EnumType\StatusChangeTypeEnum::valueIsValid()
     * @uses \EnumType\StatusChangeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateType
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public function setUpdateType($updateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusChangeTypeEnum::valueIsValid($updateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $updateType, implode(', ', \EnumType\StatusChangeTypeEnum::getValidValues())), __LINE__);
        }
        $this->updateType = $updateType;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get newStatus value
     * @return string|null
     */
    public function getNewStatus()
    {
        return $this->newStatus;
    }
    /**
     * Set newStatus value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newStatus
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public function setNewStatus($newStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($newStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $newStatus, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->newStatus = $newStatus;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountStatusChangeRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
