<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountSearchRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:accountSearchRequestImpl
 * @subpackage Structs
 */
class AccountSearchRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The secondarySvcType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondarySvcType;
    /**
     * The secondarySvcStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secondarySvcStatus;
    /**
     * The dateSearchType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateSearchType;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The filterType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filterType;
    /**
     * The filterCond
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filterCond;
    /**
     * The filterValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filterValue;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for accountSearchRequestImpl
     * @uses AccountSearchRequestImpl::setServiceType()
     * @uses AccountSearchRequestImpl::setStatus()
     * @uses AccountSearchRequestImpl::setSecondarySvcType()
     * @uses AccountSearchRequestImpl::setSecondarySvcStatus()
     * @uses AccountSearchRequestImpl::setDateSearchType()
     * @uses AccountSearchRequestImpl::setStartDate()
     * @uses AccountSearchRequestImpl::setEndDate()
     * @uses AccountSearchRequestImpl::setFilterType()
     * @uses AccountSearchRequestImpl::setFilterCond()
     * @uses AccountSearchRequestImpl::setFilterValue()
     * @uses AccountSearchRequestImpl::setLimit()
     * @uses AccountSearchRequestImpl::setStartRow()
     * @param string $serviceType
     * @param string $status
     * @param string $secondarySvcType
     * @param string $secondarySvcStatus
     * @param string $dateSearchType
     * @param string $startDate
     * @param string $endDate
     * @param string $filterType
     * @param string $filterCond
     * @param string $filterValue
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($serviceType = null, $status = null, $secondarySvcType = null, $secondarySvcStatus = null, $dateSearchType = null, $startDate = null, $endDate = null, $filterType = null, $filterCond = null, $filterValue = null, $limit = null, $startRow = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setStatus($status)
            ->setSecondarySvcType($secondarySvcType)
            ->setSecondarySvcStatus($secondarySvcStatus)
            ->setDateSearchType($dateSearchType)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setFilterType($filterType)
            ->setFilterCond($filterCond)
            ->setFilterValue($filterValue)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get secondarySvcType value
     * @return string|null
     */
    public function getSecondarySvcType()
    {
        return $this->secondarySvcType;
    }
    /**
     * Set secondarySvcType value
     * @uses \EnumType\SecondarySvcTypeEnum::valueIsValid()
     * @uses \EnumType\SecondarySvcTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $secondarySvcType
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setSecondarySvcType($secondarySvcType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SecondarySvcTypeEnum::valueIsValid($secondarySvcType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $secondarySvcType, implode(', ', \EnumType\SecondarySvcTypeEnum::getValidValues())), __LINE__);
        }
        $this->secondarySvcType = $secondarySvcType;
        return $this;
    }
    /**
     * Get secondarySvcStatus value
     * @return string|null
     */
    public function getSecondarySvcStatus()
    {
        return $this->secondarySvcStatus;
    }
    /**
     * Set secondarySvcStatus value
     * @uses \EnumType\SecondarySvcStatusEnum::valueIsValid()
     * @uses \EnumType\SecondarySvcStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $secondarySvcStatus
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setSecondarySvcStatus($secondarySvcStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SecondarySvcStatusEnum::valueIsValid($secondarySvcStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $secondarySvcStatus, implode(', ', \EnumType\SecondarySvcStatusEnum::getValidValues())), __LINE__);
        }
        $this->secondarySvcStatus = $secondarySvcStatus;
        return $this;
    }
    /**
     * Get dateSearchType value
     * @return string|null
     */
    public function getDateSearchType()
    {
        return $this->dateSearchType;
    }
    /**
     * Set dateSearchType value
     * @uses \EnumType\DateRangeTypeEnum::valueIsValid()
     * @uses \EnumType\DateRangeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateSearchType
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setDateSearchType($dateSearchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DateRangeTypeEnum::valueIsValid($dateSearchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dateSearchType, implode(', ', \EnumType\DateRangeTypeEnum::getValidValues())), __LINE__);
        }
        $this->dateSearchType = $dateSearchType;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get filterType value
     * @return string|null
     */
    public function getFilterType()
    {
        return $this->filterType;
    }
    /**
     * Set filterType value
     * @uses \EnumType\SubscriberAccountSearchTypeEnum::valueIsValid()
     * @uses \EnumType\SubscriberAccountSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterType
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setFilterType($filterType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubscriberAccountSearchTypeEnum::valueIsValid($filterType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $filterType, implode(', ', \EnumType\SubscriberAccountSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->filterType = $filterType;
        return $this;
    }
    /**
     * Get filterCond value
     * @return string|null
     */
    public function getFilterCond()
    {
        return $this->filterCond;
    }
    /**
     * Set filterCond value
     * @uses \EnumType\SearchCondEnum::valueIsValid()
     * @uses \EnumType\SearchCondEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterCond
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setFilterCond($filterCond = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchCondEnum::valueIsValid($filterCond)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $filterCond, implode(', ', \EnumType\SearchCondEnum::getValidValues())), __LINE__);
        }
        $this->filterCond = $filterCond;
        return $this;
    }
    /**
     * Get filterValue value
     * @return string|null
     */
    public function getFilterValue()
    {
        return $this->filterValue;
    }
    /**
     * Set filterValue value
     * @param string $filterValue
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setFilterValue($filterValue = null)
    {
        // validation for constraint: string
        if (!is_null($filterValue) && !is_string($filterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filterValue)), __LINE__);
        }
        $this->filterValue = $filterValue;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\AccountSearchRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountSearchRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
