<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountSearchReportImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:accountSearchReportImpl
 * @subpackage Structs
 */
class AccountSearchReportImpl extends AbstractStructBase
{
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The details
     * @var string
     */
    public $details;
    /**
     * The activationDate
     * @var string
     */
    public $activationDate;
    /**
     * The lastUpdated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastUpdated;
    /**
     * The accountStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountStatus;
    /**
     * Constructor method for accountSearchReportImpl
     * @uses AccountSearchReportImpl::setAccountNumber()
     * @uses AccountSearchReportImpl::setServiceType()
     * @uses AccountSearchReportImpl::setDetails()
     * @uses AccountSearchReportImpl::setActivationDate()
     * @uses AccountSearchReportImpl::setLastUpdated()
     * @uses AccountSearchReportImpl::setAccountStatus()
     * @param string $accountNumber
     * @param string $serviceType
     * @param string $details
     * @param string $activationDate
     * @param string $lastUpdated
     * @param string $accountStatus
     */
    public function __construct($accountNumber = null, $serviceType = null, $details = null, $activationDate = null, $lastUpdated = null, $accountStatus = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setServiceType($serviceType)
            ->setDetails($details)
            ->setActivationDate($activationDate)
            ->setLastUpdated($lastUpdated)
            ->setAccountStatus($accountStatus);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\AccountSearchReportImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \StructType\AccountSearchReportImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get details value
     * @return string|null
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param string $details
     * @return \StructType\AccountSearchReportImpl
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($details)), __LINE__);
        }
        $this->details = $details;
        return $this;
    }
    /**
     * Get activationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->activationDate;
    }
    /**
     * Set activationDate value
     * @param string $activationDate
     * @return \StructType\AccountSearchReportImpl
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationDate)), __LINE__);
        }
        $this->activationDate = $activationDate;
        return $this;
    }
    /**
     * Get lastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->lastUpdated;
    }
    /**
     * Set lastUpdated value
     * @param string $lastUpdated
     * @return \StructType\AccountSearchReportImpl
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->lastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\AccountSearchReportImpl
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountStatus, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountSearchReportImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
