<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for accountPoolingGroupImpl StructType
 * @subpackage Structs
 */
class AccountPoolingGroupImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The planName
     * @var string
     */
    public $planName;
    /**
     * The planType
     * @var string
     */
    public $planType;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The totalNumberOfMemberAccounts
     * @var int
     */
    public $totalNumberOfMemberAccounts;
    /**
     * The memberAccounts
     * @var \StructType\MemberAccounts
     */
    public $memberAccounts;
    /**
     * Constructor method for accountPoolingGroupImpl
     * @uses AccountPoolingGroupImpl::setId()
     * @uses AccountPoolingGroupImpl::setStatus()
     * @uses AccountPoolingGroupImpl::setName()
     * @uses AccountPoolingGroupImpl::setPlanName()
     * @uses AccountPoolingGroupImpl::setPlanType()
     * @uses AccountPoolingGroupImpl::setDescription()
     * @uses AccountPoolingGroupImpl::setTotalNumberOfMemberAccounts()
     * @uses AccountPoolingGroupImpl::setMemberAccounts()
     * @param string $id
     * @param string $status
     * @param string $name
     * @param string $planName
     * @param string $planType
     * @param string $description
     * @param int $totalNumberOfMemberAccounts
     * @param \StructType\MemberAccounts $memberAccounts
     */
    public function __construct($id = null, $status = null, $name = null, $planName = null, $planType = null, $description = null, $totalNumberOfMemberAccounts = null, \StructType\MemberAccounts $memberAccounts = null)
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setName($name)
            ->setPlanName($planName)
            ->setPlanType($planType)
            ->setDescription($description)
            ->setTotalNumberOfMemberAccounts($totalNumberOfMemberAccounts)
            ->setMemberAccounts($memberAccounts);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusEnum::valueIsValid()
     * @uses \EnumType\StatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\StatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get planName value
     * @return string|null
     */
    public function getPlanName()
    {
        return $this->planName;
    }
    /**
     * Set planName value
     * @param string $planName
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setPlanName($planName = null)
    {
        // validation for constraint: string
        if (!is_null($planName) && !is_string($planName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planName)), __LINE__);
        }
        $this->planName = $planName;
        return $this;
    }
    /**
     * Get planType value
     * @return string|null
     */
    public function getPlanType()
    {
        return $this->planType;
    }
    /**
     * Set planType value
     * @uses \EnumType\PoolGroupTypeEnum::valueIsValid()
     * @uses \EnumType\PoolGroupTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planType
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setPlanType($planType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PoolGroupTypeEnum::valueIsValid($planType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $planType, implode(', ', \EnumType\PoolGroupTypeEnum::getValidValues())), __LINE__);
        }
        $this->planType = $planType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get totalNumberOfMemberAccounts value
     * @return int|null
     */
    public function getTotalNumberOfMemberAccounts()
    {
        return $this->totalNumberOfMemberAccounts;
    }
    /**
     * Set totalNumberOfMemberAccounts value
     * @param int $totalNumberOfMemberAccounts
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setTotalNumberOfMemberAccounts($totalNumberOfMemberAccounts = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfMemberAccounts) && !is_numeric($totalNumberOfMemberAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfMemberAccounts)), __LINE__);
        }
        $this->totalNumberOfMemberAccounts = $totalNumberOfMemberAccounts;
        return $this;
    }
    /**
     * Get memberAccounts value
     * @return \StructType\MemberAccounts|null
     */
    public function getMemberAccounts()
    {
        return $this->memberAccounts;
    }
    /**
     * Set memberAccounts value
     * @param \StructType\MemberAccounts $memberAccounts
     * @return \StructType\AccountPoolingGroupImpl
     */
    public function setMemberAccounts(\StructType\MemberAccounts $memberAccounts = null)
    {
        $this->memberAccounts = $memberAccounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountPoolingGroupImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
