<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchDeviceUsage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceUsageReportRequestImpl $request
     * @return \StructType\GetDeviceUsageReportResponseImpl|bool
     */
    public function searchDeviceUsage(\StructType\GetDeviceUsageReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->searchDeviceUsage($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchVoucherOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchVoucherInventoryRequestImpl $request
     * @return \StructType\SearchVoucherInventoryResponseImpl|bool
     */
    public function searchVoucherOrder(\StructType\SearchVoucherInventoryRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->searchVoucherOrder($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSimLock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchSimLockRequestImpl $request
     * @return \StructType\SearchSimLockResponseImpl|bool
     */
    public function searchSimLock(\StructType\SearchSimLockRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->searchSimLock($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDeviceUsageReportResponseImpl|\StructType\SearchSimLockResponseImpl|\StructType\SearchVoucherInventoryResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
