<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Restricted ServiceType
 * @subpackage Services
 */
class Restricted extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named restrictedSimSwap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RestrictedSimSwapRequestImpl $request
     * @return \StructType\RestrictedSimSwapResponseImpl|bool
     */
    public function restrictedSimSwap(\StructType\RestrictedSimSwapRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->restrictedSimSwap($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RestrictedSimSwapResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
