<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reset ServiceType
 * @subpackage Services
 */
class Reset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named resetUserPassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetUserPasswordRequestImpl $request
     * @return \StructType\ResetUserPasswordResponseImpl|bool
     */
    public function resetUserPassword(\StructType\ResetUserPasswordRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->resetUserPassword($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named resetTelephonyVMPin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetTelephonyVMPinRequestImpl $request
     * @return \StructType\IwsResponseImpl|bool
     */
    public function resetTelephonyVMPin(\StructType\ResetTelephonyVMPinRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->resetTelephonyVMPin($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IwsResponseImpl|\StructType\ResetUserPasswordResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
