<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refund ServiceType
 * @subpackage Services
 */
class Refund extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named refundPrepaidVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RefundPrepaidVoucherRequestImpl $request
     * @return \StructType\RefundPrepaidVoucherResponseImpl|bool
     */
    public function refundPrepaidVoucher(\StructType\RefundPrepaidVoucherRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->refundPrepaidVoucher($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RefundPrepaidVoucherResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
