<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getModels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModelsRequestImpl $request
     * @return \StructType\GetModelsResponseImpl|bool
     */
    public function getModels(\StructType\GetModelsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getModels($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrepaidAccountDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrepaidAccountDetailRequestImpl $request
     * @return \StructType\GetPrepaidAccountDetailResponseImpl|bool
     */
    public function getPrepaidAccountDetail(\StructType\GetPrepaidAccountDetailRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrepaidAccountDetail($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEmailNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmailNotificationRequestImpl $request
     * @return \StructType\GetEmailNotificationResponseImpl|bool
     */
    public function getEmailNotification(\StructType\GetEmailNotificationRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getEmailNotification($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRechargeHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRechargeHistoryRequestImpl $request
     * @return \StructType\GetRechargeHistoryResponseImpl|bool
     */
    public function getRechargeHistory(\StructType\GetRechargeHistoryRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getRechargeHistory($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRolesRequestImpl $request
     * @return \StructType\GetRolesResponseImpl|bool
     */
    public function getRoles(\StructType\GetRolesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getRoles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrepaidAccountSummary
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrepaidAccountSummaryRequestImpl $request
     * @return \StructType\GetPrepaidAccountSummaryResponseImpl|bool
     */
    public function getPrepaidAccountSummary(\StructType\GetPrepaidAccountSummaryRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrepaidAccountSummary($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAirlines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAirlinesRequestImpl $request
     * @return \StructType\GetAirlinesResponseImpl|bool
     */
    public function getAirlines(\StructType\GetAirlinesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getAirlines($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerticals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVerticalsRequestImpl $request
     * @return \StructType\GetVerticalsResponseImpl|bool
     */
    public function getVerticals(\StructType\GetVerticalsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getVerticals($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubscriberAccount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriberAccountRequestImpl $request
     * @return \StructType\GetSubscriberAccountResponseImpl|bool
     */
    public function getSubscriberAccount(\StructType\GetSubscriberAccountRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubscriberAccount($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEvoucherInventory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEvoucherInventoryRequestImpl $request
     * @return \StructType\GetEvoucherInventoryResponseImpl|bool
     */
    public function getEvoucherInventory(\StructType\GetEvoucherInventoryRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getEvoucherInventory($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocalNumberRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocalNumberRegionsRequestImpl $request
     * @return \StructType\GetLocalNumberRegionsResponseImpl|bool
     */
    public function getLocalNumberRegions(\StructType\GetLocalNumberRegionsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getLocalNumberRegions($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getScratchCardBatches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetScratchCardBatchesRequestImpl $request
     * @return \StructType\GetScratchCardBatchesResponseImpl|bool
     */
    public function getScratchCardBatches(\StructType\GetScratchCardBatchesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getScratchCardBatches($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallSummaryReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallSummaryReportRequestImpl $request
     * @return \StructType\GetCallSummaryReportResponseImpl|bool
     */
    public function getCallSummaryReport(\StructType\GetCallSummaryReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getCallSummaryReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrepaidCallHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrepaidCallHistoryRequestImpl $request
     * @return \StructType\GetPrepaidCallHistoryResponseImpl|bool
     */
    public function getPrepaidCallHistory(\StructType\GetPrepaidCallHistoryRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrepaidCallHistory($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDataSpeeds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataSpeedsRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getDataSpeeds(\StructType\GetDataSpeedsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getDataSpeeds($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoucherDenominations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoucherDenominationsRequestImpl $request
     * @return \StructType\GetVoucherDenominationsResponseImpl|bool
     */
    public function getVoucherDenominations(\StructType\GetVoucherDenominationsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoucherDenominations($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrepaidPlans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPrepaidPlansRequestImpl $request
     * @return \StructType\GetPrepaidPlansResponseImpl|bool
     */
    public function getPrepaidPlans(\StructType\GetPrepaidPlansRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getPrepaidPlans($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubscriberBaseReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriberBaseReportRequestImpl $request
     * @return \StructType\GetSubscriberBaseReportResponseImpl|bool
     */
    public function getSubscriberBaseReport(\StructType\GetSubscriberBaseReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubscriberBaseReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDevicesRequestImpl $request
     * @return \StructType\GetDevicesResponseImpl|bool
     */
    public function getDevices(\StructType\GetDevicesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getDevices($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDataBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getDataBundles(\StructType\GetDataBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getDataBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDemoAndTrialBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDemoAndTrialBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getDemoAndTrialBundles(\StructType\GetDemoAndTrialBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getDemoAndTrialBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBurstDeviceBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBurstDeviceBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getBurstDeviceBundles(\StructType\GetBurstDeviceBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getBurstDeviceBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransactionHistoryReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransactionHistoryReportRequestImpl $request
     * @return \StructType\GetTransactionHistoryReportResponseImpl|bool
     */
    public function getTransactionHistoryReport(\StructType\GetTransactionHistoryReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getTransactionHistoryReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountTransitionReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AccountTransitionReportRequestImpl $request
     * @return \StructType\AccountTransitionReportResponseImpl|bool
     */
    public function getAccountTransitionReport(\StructType\AccountTransitionReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccountTransitionReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRealTimeCallDataReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRealTimeCallDataReportRequestImpl $request
     * @return \StructType\GetRealTimeCallDataReportResponseImpl|bool
     */
    public function getRealTimeCallDataReport(\StructType\GetRealTimeCallDataReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getRealTimeCallDataReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBurstBroadcastCoverageAreas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBurstBroadcastCoverageAreasRequestImpl $request
     * @return \StructType\GetBurstBroadcastCoverageAreasResponseImpl|bool
     */
    public function getBurstBroadcastCoverageAreas(\StructType\GetBurstBroadcastCoverageAreasRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getBurstBroadcastCoverageAreas($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSBDBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSBDBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getSBDBundles(\StructType\GetSBDBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSBDBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubscriberOrgDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubscriberOrgDetailReqImpl $request
     * @return \StructType\SubscriberOrgDetailRespImpl|bool
     */
    public function getSubscriberOrgDetail(\StructType\SubscriberOrgDetailReqImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubscriberOrgDetail($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLanguages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguagesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getLanguages(\StructType\GetLanguagesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getLanguages($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getManufacturers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetManufacturersRequestImpl $request
     * @return \StructType\GetManufacturersResponseImpl|bool
     */
    public function getManufacturers(\StructType\GetManufacturersRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getManufacturers($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBulkActionRequestReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBulkActionReportRequestImpl $request
     * @return \StructType\SearchAccountResponseImpl|bool
     */
    public function getBulkActionRequestReport(\StructType\GetBulkActionReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getBulkActionRequestReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommitmentPeriods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommitmentPeriodsRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getCommitmentPeriods(\StructType\GetCommitmentPeriodsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getCommitmentPeriods($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBundle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBundleRequestImpl $request
     * @return \StructType\GetBundleResponseImpl|bool
     */
    public function getBundle(\StructType\GetBundleRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getBundle($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRudicsGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRudicsGroupsRequestImpl $request
     * @return \StructType\GetRudicsGroupsResponseImpl|bool
     */
    public function getRudicsGroups(\StructType\GetRudicsGroupsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getRudicsGroups($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSystemStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AuthenticatedIwsRequestImpl $request
     * @return \StructType\GetSystemStatusResponseImpl|bool
     */
    public function getSystemStatus(\StructType\AuthenticatedIwsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSystemStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getM2MBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetM2MBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getM2MBundles(\StructType\GetM2MBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getM2MBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModelRequestImpl $request
     * @return \StructType\GetModelResponseImpl|bool
     */
    public function getModel(\StructType\GetModelRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getModel($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourceInventoryReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResourceInventoryReportRequestImpl $request
     * @return \StructType\GetResourceInventoryReportResponseImpl|bool
     */
    public function getResourceInventoryReport(\StructType\GetResourceInventoryReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getResourceInventoryReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVCSBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVCSBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getVCSBundles(\StructType\GetVCSBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getVCSBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServicePlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePlanRequestImpl $request
     * @return \StructType\GetServicePlanResponseImpl|bool
     */
    public function getServicePlan(\StructType\GetServicePlanRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getServicePlan($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubscriberOrganizations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriberOrgsRequestImpl $request
     * @return \StructType\SubscriberOrgsResponseImpl|bool
     */
    public function getSubscriberOrganizations(\StructType\GetSubscriberOrgsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubscriberOrganizations($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountPoolingGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountPoolingGroupsRequestImpl $request
     * @return \StructType\GetAccountPoolingGroupsResponseImpl|bool
     */
    public function getAccountPoolingGroups(\StructType\GetAccountPoolingGroupsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccountPoolingGroups($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServicePlans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicePlansRequestImpl $request
     * @return \StructType\GetServicePlansResponseImpl|bool
     */
    public function getServicePlans(\StructType\GetServicePlansRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getServicePlans($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoiceBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getVoiceBundles(\StructType\GetVoiceBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoiceBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProgrammableButtons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProgrammableButtonsRequestImpl $request
     * @return \StructType\GetProgrammableButtonsResponseImpl|bool
     */
    public function getProgrammableButtons(\StructType\GetProgrammableButtonsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getProgrammableButtons($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getScratchCardActivationStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchScratchCardActivationStatusRequestImpl $request
     * @return \StructType\SearchScratchCardActivationStatusResponseImpl|bool
     */
    public function getScratchCardActivationStatus(\StructType\SearchScratchCardActivationStatusRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getScratchCardActivationStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getScratchCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetScratchCardsRequestImpl $request
     * @return \StructType\GetScratchCardsResponseImpl|bool
     */
    public function getScratchCards(\StructType\GetScratchCardsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getScratchCards($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLanguageChoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguageChoicesRequestImpl $request
     * @return \StructType\GetLanguageChoicesResponseImpl|bool
     */
    public function getLanguageChoices(\StructType\GetLanguageChoicesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getLanguageChoices($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPromoBundles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPromoBundlesRequestImpl $request
     * @return \StructType\GetBundlesResponseImpl|bool
     */
    public function getPromoBundles(\StructType\GetPromoBundlesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getPromoBundles($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSubmarkets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubmarketsRequestImpl $request
     * @return \StructType\GetSubmarketsResponseImpl|bool
     */
    public function getSubmarkets(\StructType\GetSubmarketsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getSubmarkets($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDemoAndTrialCounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDemoAndTrialCountsRequestImpl $request
     * @return \StructType\GetDemoAndTrialCountsResponseImpl|bool
     */
    public function getDemoAndTrialCounts(\StructType\GetDemoAndTrialCountsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getDemoAndTrialCounts($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProvisioningFailureReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProvisioningFailureReportRequestImpl $request
     * @return \StructType\GetProvisioningFailureReportResponseImpl|bool
     */
    public function getProvisioningFailureReport(\StructType\GetProvisioningFailureReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getProvisioningFailureReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccountPoolingGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountPoolingGroupRequestImpl $request
     * @return \StructType\GetAccountPoolingGroupResponseImpl|bool
     */
    public function getAccountPoolingGroup(\StructType\GetAccountPoolingGroupRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccountPoolingGroup($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBurstSubscriptionNames
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBurstSubscriptionNamesRequestImpl $request
     * @return \StructType\GetBurstSubscriptionNamesResponseImpl|bool
     */
    public function getBurstSubscriptionNames(\StructType\GetBurstSubscriptionNamesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->getBurstSubscriptionNames($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AccountTransitionReportResponseImpl|\StructType\GetAccountPoolingGroupResponseImpl|\StructType\GetAccountPoolingGroupsResponseImpl|\StructType\GetAirlinesResponseImpl|\StructType\GetBundleResponseImpl|\StructType\GetBundlesResponseImpl|\StructType\GetBurstBroadcastCoverageAreasResponseImpl|\StructType\GetBurstSubscriptionNamesResponseImpl|\StructType\GetCallSummaryReportResponseImpl|\StructType\GetDemoAndTrialCountsResponseImpl|\StructType\GetDevicesResponseImpl|\StructType\GetEmailNotificationResponseImpl|\StructType\GetEvoucherInventoryResponseImpl|\StructType\GetLanguageChoicesResponseImpl|\StructType\GetLocalNumberRegionsResponseImpl|\StructType\GetManufacturersResponseImpl|\StructType\GetModelResponseImpl|\StructType\GetModelsResponseImpl|\StructType\GetPrepaidAccountDetailResponseImpl|\StructType\GetPrepaidAccountSummaryResponseImpl|\StructType\GetPrepaidCallHistoryResponseImpl|\StructType\GetPrepaidPlansResponseImpl|\StructType\GetProgrammableButtonsResponseImpl|\StructType\GetProvisioningFailureReportResponseImpl|\StructType\GetRealTimeCallDataReportResponseImpl|\StructType\GetRechargeHistoryResponseImpl|\StructType\GetResourceInventoryReportResponseImpl|\StructType\GetRolesResponseImpl|\StructType\GetRudicsGroupsResponseImpl|\StructType\GetScratchCardBatchesResponseImpl|\StructType\GetScratchCardsResponseImpl|\StructType\GetServicePlanResponseImpl|\StructType\GetServicePlansResponseImpl|\StructType\GetSubmarketsResponseImpl|\StructType\GetSubscriberAccountResponseImpl|\StructType\GetSubscriberBaseReportResponseImpl|\StructType\GetSystemStatusResponseImpl|\StructType\GetTransactionHistoryReportResponseImpl|\StructType\GetVerticalsResponseImpl|\StructType\GetVoucherDenominationsResponseImpl|\StructType\SearchAccountResponseImpl|\StructType\SearchScratchCardActivationStatusResponseImpl|\StructType\SubscriberOrgDetailRespImpl|\StructType\SubscriberOrgsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
