<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bulkAccountUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkAccountUpdateRequestImpl $request
     * @return \StructType\BulkAccountUpdateResponseImpl|bool
     */
    public function bulkAccountUpdate(\StructType\BulkAccountUpdateRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->bulkAccountUpdate($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named bulkActionSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkActionSearchRequestImpl $request
     * @return \StructType\BulkActionSearchResponseImpl|bool
     */
    public function bulkActionSearch(\StructType\BulkActionSearchRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->bulkActionSearch($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BulkAccountUpdateResponseImpl|\StructType\BulkActionSearchResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
