<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Activate ServiceType
 * @subpackage Services
 */
class Activate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named activateTelephonyScratchCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivateTelephonyScratchCardsRequestImpl $request
     * @return \StructType\ActivateTelephonyScratchCardsResponseImpl|bool
     */
    public function activateTelephonyScratchCards(\StructType\ActivateTelephonyScratchCardsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->activateTelephonyScratchCards($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named activateSubscriber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivateSubscriberRequestImpl $request
     * @return \StructType\ActivateSubscriberResponseImpl|bool
     */
    public function activateSubscriber(\StructType\ActivateSubscriberRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->activateSubscriber($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named activateScratchCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivateScratchCardRequestImpl $request
     * @return \StructType\ActivateScratchCardResponseImpl|bool
     */
    public function activateScratchCards(\StructType\ActivateScratchCardRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->activateScratchCards($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ActivateScratchCardResponseImpl|\StructType\ActivateSubscriberResponseImpl|\StructType\ActivateTelephonyScratchCardsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
