<?php

namespace EnumType;

/**
 * This class stands for voucherOrderSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class VoucherOrderSearchTypeEnum
{
    /**
     * Constant for value 'PURCHASE_ORDER'
     * @return string 'PURCHASE_ORDER'
     */
    const VALUE_PURCHASE_ORDER = 'PURCHASE_ORDER';
    /**
     * Constant for value 'SERIAL_NUMBER'
     * @return string 'SERIAL_NUMBER'
     */
    const VALUE_SERIAL_NUMBER = 'SERIAL_NUMBER';
    /**
     * Constant for value 'BATCH_ID'
     * @return string 'BATCH_ID'
     */
    const VALUE_BATCH_ID = 'BATCH_ID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PURCHASE_ORDER
     * @uses self::VALUE_SERIAL_NUMBER
     * @uses self::VALUE_BATCH_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PURCHASE_ORDER,
            self::VALUE_SERIAL_NUMBER,
            self::VALUE_BATCH_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
