<?php

namespace EnumType;

/**
 * This class stands for voucherActionTypeEnum EnumType
 * @subpackage Enumerations
 */
class VoucherActionTypeEnum
{
    /**
     * Constant for value 'ACTIVATE'
     * @return string 'ACTIVATE'
     */
    const VALUE_ACTIVATE = 'ACTIVATE';
    /**
     * Constant for value 'RECHARGE'
     * @return string 'RECHARGE'
     */
    const VALUE_RECHARGE = 'RECHARGE';
    /**
     * Constant for value 'REFUND'
     * @return string 'REFUND'
     */
    const VALUE_REFUND = 'REFUND';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVATE
     * @uses self::VALUE_RECHARGE
     * @uses self::VALUE_REFUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVATE,
            self::VALUE_RECHARGE,
            self::VALUE_REFUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
