<?php

namespace EnumType;

/**
 * This class stands for userStatusEnum EnumType
 * @subpackage Enumerations
 */
class UserStatusEnum
{
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'INACTIVE'
     * @return string 'INACTIVE'
     */
    const VALUE_INACTIVE = 'INACTIVE';
    /**
     * Constant for value 'CLOSED'
     * @return string 'CLOSED'
     */
    const VALUE_CLOSED = 'CLOSED';
    /**
     * Constant for value 'EXPIRED'
     * @return string 'EXPIRED'
     */
    const VALUE_EXPIRED = 'EXPIRED';
    /**
     * Constant for value 'LOCKED'
     * @return string 'LOCKED'
     */
    const VALUE_LOCKED = 'LOCKED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_INACTIVE
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_EXPIRED
     * @uses self::VALUE_LOCKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_INACTIVE,
            self::VALUE_CLOSED,
            self::VALUE_EXPIRED,
            self::VALUE_LOCKED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
