<?php

namespace EnumType;

/**
 * This class stands for telephonyScratchCardSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class TelephonyScratchCardSearchTypeEnum
{
    /**
     * Constant for value 'SERIAL_NUMBER'
     * @return string 'SERIAL_NUMBER'
     */
    const VALUE_SERIAL_NUMBER = 'SERIAL_NUMBER';
    /**
     * Constant for value 'BATCH_NUMBER'
     * @return string 'BATCH_NUMBER'
     */
    const VALUE_BATCH_NUMBER = 'BATCH_NUMBER';
    /**
     * Constant for value 'DISTR_TYPE'
     * @return string 'DISTR_TYPE'
     */
    const VALUE_DISTR_TYPE = 'DISTR_TYPE';
    /**
     * Constant for value 'EXPIRY_DATE'
     * @return string 'EXPIRY_DATE'
     */
    const VALUE_EXPIRY_DATE = 'EXPIRY_DATE';
    /**
     * Constant for value 'ACT_DATE'
     * @return string 'ACT_DATE'
     */
    const VALUE_ACT_DATE = 'ACT_DATE';
    /**
     * Constant for value 'FIRST_USE_DATE'
     * @return string 'FIRST_USE_DATE'
     */
    const VALUE_FIRST_USE_DATE = 'FIRST_USE_DATE';
    /**
     * Constant for value 'BALANCE'
     * @return string 'BALANCE'
     */
    const VALUE_BALANCE = 'BALANCE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERIAL_NUMBER
     * @uses self::VALUE_BATCH_NUMBER
     * @uses self::VALUE_DISTR_TYPE
     * @uses self::VALUE_EXPIRY_DATE
     * @uses self::VALUE_ACT_DATE
     * @uses self::VALUE_FIRST_USE_DATE
     * @uses self::VALUE_BALANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERIAL_NUMBER,
            self::VALUE_BATCH_NUMBER,
            self::VALUE_DISTR_TYPE,
            self::VALUE_EXPIRY_DATE,
            self::VALUE_ACT_DATE,
            self::VALUE_FIRST_USE_DATE,
            self::VALUE_BALANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
