<?php

namespace EnumType;

/**
 * This class stands for streamingSpeedEnum EnumType
 * @subpackage Enumerations
 */
class StreamingSpeedEnum
{
    /**
     * Constant for value 'KBPS4_8'
     * @return string 'KBPS4_8'
     */
    const VALUE_KBPS_4_8 = 'KBPS4_8';
    /**
     * Constant for value 'KBPS9_6'
     * @return string 'KBPS9_6'
     */
    const VALUE_KBPS_9_6 = 'KBPS9_6';
    /**
     * Constant for value 'KBPS14_4'
     * @return string 'KBPS14_4'
     */
    const VALUE_KBPS_14_4 = 'KBPS14_4';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KBPS_4_8
     * @uses self::VALUE_KBPS_9_6
     * @uses self::VALUE_KBPS_14_4
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KBPS_4_8,
            self::VALUE_KBPS_9_6,
            self::VALUE_KBPS_14_4,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
