<?php

namespace EnumType;

/**
 * This class stands for serviceProviderProfileConfigTypeEnum EnumType
 * @subpackage Enumerations
 */
class ServiceProviderProfileConfigTypeEnum
{
    /**
     * Constant for value 'OPEN_PORT'
     * @return string 'OPEN_PORT'
     */
    const VALUE_OPEN_PORT = 'OPEN_PORT';
    /**
     * Constant for value 'TELPREPAID'
     * @return string 'TELPREPAID'
     */
    const VALUE_TELPREPAID = 'TELPREPAID';
    /**
     * Constant for value 'TELEPHONY'
     * @return string 'TELEPHONY'
     */
    const VALUE_TELEPHONY = 'TELEPHONY';
    /**
     * Constant for value 'PAGING'
     * @return string 'PAGING'
     */
    const VALUE_PAGING = 'PAGING';
    /**
     * Constant for value 'ATS'
     * @return string 'ATS'
     */
    const VALUE_ATS = 'ATS';
    /**
     * Constant for value 'SHORT_BURST_DATA'
     * @return string 'SHORT_BURST_DATA'
     */
    const VALUE_SHORT_BURST_DATA = 'SHORT_BURST_DATA';
    /**
     * Constant for value 'MACHINE_TO_MACHINE'
     * @return string 'MACHINE_TO_MACHINE'
     */
    const VALUE_MACHINE_TO_MACHINE = 'MACHINE_TO_MACHINE';
    /**
     * Constant for value 'BURST_DEVICE'
     * @return string 'BURST_DEVICE'
     */
    const VALUE_BURST_DEVICE = 'BURST_DEVICE';
    /**
     * Constant for value 'BURST_SERVICE'
     * @return string 'BURST_SERVICE'
     */
    const VALUE_BURST_SERVICE = 'BURST_SERVICE';
    /**
     * Constant for value 'PTT_DEVICE'
     * @return string 'PTT_DEVICE'
     */
    const VALUE_PTT_DEVICE = 'PTT_DEVICE';
    /**
     * Constant for value 'PTT_TALKGROUP'
     * @return string 'PTT_TALKGROUP'
     */
    const VALUE_PTT_TALKGROUP = 'PTT_TALKGROUP';
    /**
     * Constant for value 'SCRATCHCARD'
     * @return string 'SCRATCHCARD'
     */
    const VALUE_SCRATCHCARD = 'SCRATCHCARD';
    /**
     * Constant for value 'CERTUS'
     * @return string 'CERTUS'
     */
    const VALUE_CERTUS = 'CERTUS';
    /**
     * Constant for value 'CERTUS_AV'
     * @return string 'CERTUS_AV'
     */
    const VALUE_CERTUS_AV = 'CERTUS_AV';
    /**
     * Constant for value 'CERTUS_MAR'
     * @return string 'CERTUS_MAR'
     */
    const VALUE_CERTUS_MAR = 'CERTUS_MAR';
    /**
     * Constant for value 'CERTUS_LM'
     * @return string 'CERTUS_LM'
     */
    const VALUE_CERTUS_LM = 'CERTUS_LM';
    /**
     * Constant for value 'CERTUS_VAM'
     * @return string 'CERTUS_VAM'
     */
    const VALUE_CERTUS_VAM = 'CERTUS_VAM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPEN_PORT
     * @uses self::VALUE_TELPREPAID
     * @uses self::VALUE_TELEPHONY
     * @uses self::VALUE_PAGING
     * @uses self::VALUE_ATS
     * @uses self::VALUE_SHORT_BURST_DATA
     * @uses self::VALUE_MACHINE_TO_MACHINE
     * @uses self::VALUE_BURST_DEVICE
     * @uses self::VALUE_BURST_SERVICE
     * @uses self::VALUE_PTT_DEVICE
     * @uses self::VALUE_PTT_TALKGROUP
     * @uses self::VALUE_SCRATCHCARD
     * @uses self::VALUE_CERTUS
     * @uses self::VALUE_CERTUS_AV
     * @uses self::VALUE_CERTUS_MAR
     * @uses self::VALUE_CERTUS_LM
     * @uses self::VALUE_CERTUS_VAM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPEN_PORT,
            self::VALUE_TELPREPAID,
            self::VALUE_TELEPHONY,
            self::VALUE_PAGING,
            self::VALUE_ATS,
            self::VALUE_SHORT_BURST_DATA,
            self::VALUE_MACHINE_TO_MACHINE,
            self::VALUE_BURST_DEVICE,
            self::VALUE_BURST_SERVICE,
            self::VALUE_PTT_DEVICE,
            self::VALUE_PTT_TALKGROUP,
            self::VALUE_SCRATCHCARD,
            self::VALUE_CERTUS,
            self::VALUE_CERTUS_AV,
            self::VALUE_CERTUS_MAR,
            self::VALUE_CERTUS_LM,
            self::VALUE_CERTUS_VAM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
