<?php

namespace EnumType;

/**
 * This class stands for serviceOrderStatusEnum EnumType
 * @subpackage Enumerations
 */
class ServiceOrderStatusEnum
{
    /**
     * Constant for value 'UNUSED'
     * @return string 'UNUSED'
     */
    const VALUE_UNUSED = 'UNUSED';
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'READY'
     * @return string 'READY'
     */
    const VALUE_READY = 'READY';
    /**
     * Constant for value 'PROCESSING'
     * @return string 'PROCESSING'
     */
    const VALUE_PROCESSING = 'PROCESSING';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Constant for value 'FAILED'
     * @return string 'FAILED'
     */
    const VALUE_FAILED = 'FAILED';
    /**
     * Constant for value 'FAILED_PREPAID'
     * @return string 'FAILED_PREPAID'
     */
    const VALUE_FAILED_PREPAID = 'FAILED_PREPAID';
    /**
     * Constant for value 'INCOMPLETE'
     * @return string 'INCOMPLETE'
     */
    const VALUE_INCOMPLETE = 'INCOMPLETE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNUSED
     * @uses self::VALUE_NEW
     * @uses self::VALUE_READY
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_FAILED_PREPAID
     * @uses self::VALUE_INCOMPLETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNUSED,
            self::VALUE_NEW,
            self::VALUE_READY,
            self::VALUE_PROCESSING,
            self::VALUE_COMPLETED,
            self::VALUE_FAILED,
            self::VALUE_FAILED_PREPAID,
            self::VALUE_INCOMPLETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
