<?php

namespace EnumType;

/**
 * This class stands for serviceLanguageTypeEnum EnumType
 * @subpackage Enumerations
 */
class ServiceLanguageTypeEnum
{
    /**
     * Constant for value 'CERTUS_POSTPAID'
     * @return string 'CERTUS_POSTPAID'
     */
    const VALUE_CERTUS_POSTPAID = 'CERTUS_POSTPAID';
    /**
     * Constant for value 'CERTUS_PREPAID'
     * @return string 'CERTUS_PREPAID'
     */
    const VALUE_CERTUS_PREPAID = 'CERTUS_PREPAID';
    /**
     * Constant for value 'TELEPHONY_POSTPAID'
     * @return string 'TELEPHONY_POSTPAID'
     */
    const VALUE_TELEPHONY_POSTPAID = 'TELEPHONY_POSTPAID';
    /**
     * Constant for value 'TELEPHONY_PREPAID'
     * @return string 'TELEPHONY_PREPAID'
     */
    const VALUE_TELEPHONY_PREPAID = 'TELEPHONY_PREPAID';
    /**
     * Constant for value 'PAGING_POSTPAID'
     * @return string 'PAGING_POSTPAID'
     */
    const VALUE_PAGING_POSTPAID = 'PAGING_POSTPAID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTUS_POSTPAID
     * @uses self::VALUE_CERTUS_PREPAID
     * @uses self::VALUE_TELEPHONY_POSTPAID
     * @uses self::VALUE_TELEPHONY_PREPAID
     * @uses self::VALUE_PAGING_POSTPAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTUS_POSTPAID,
            self::VALUE_CERTUS_PREPAID,
            self::VALUE_TELEPHONY_POSTPAID,
            self::VALUE_TELEPHONY_PREPAID,
            self::VALUE_PAGING_POSTPAID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
