<?php

namespace EnumType;

/**
 * This class stands for secondarySvcStatusEnum EnumType
 * @subpackage Enumerations
 */
class SecondarySvcStatusEnum
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'NOT_ENABLED'
     * @return string 'NOT_ENABLED'
     */
    const VALUE_NOT_ENABLED = 'NOT_ENABLED';
    /**
     * Constant for value 'SUSPENDED'
     * @return string 'SUSPENDED'
     */
    const VALUE_SUSPENDED = 'SUSPENDED';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Constant for value 'REQUESTED'
     * @return string 'REQUESTED'
     */
    const VALUE_REQUESTED = 'REQUESTED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_NOT_ENABLED
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_REQUESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_ACTIVE,
            self::VALUE_NOT_ENABLED,
            self::VALUE_SUSPENDED,
            self::VALUE_ERROR,
            self::VALUE_PENDING,
            self::VALUE_REQUESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
