<?php

namespace EnumType;

/**
 * This class stands for scratchCardSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class ScratchCardSearchTypeEnum
{
    /**
     * Constant for value 'ACCOUNT_NUMBER'
     * @return string 'ACCOUNT_NUMBER'
     */
    const VALUE_ACCOUNT_NUMBER = 'ACCOUNT_NUMBER';
    /**
     * Constant for value 'PIN'
     * @return string 'PIN'
     */
    const VALUE_PIN = 'PIN';
    /**
     * Constant for value 'SERIAL_NUMBER'
     * @return string 'SERIAL_NUMBER'
     */
    const VALUE_SERIAL_NUMBER = 'SERIAL_NUMBER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_PIN
     * @uses self::VALUE_SERIAL_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_PIN,
            self::VALUE_SERIAL_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
