<?php

namespace EnumType;

/**
 * This class stands for scratchCardActivationStatusSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class ScratchCardActivationStatusSearchTypeEnum
{
    /**
     * Constant for value 'PURCHASE_ORDER'
     * @return string 'PURCHASE_ORDER'
     */
    const VALUE_PURCHASE_ORDER = 'PURCHASE_ORDER';
    /**
     * Constant for value 'REQUEST_ID'
     * @return string 'REQUEST_ID'
     */
    const VALUE_REQUEST_ID = 'REQUEST_ID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PURCHASE_ORDER
     * @uses self::VALUE_REQUEST_ID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PURCHASE_ORDER,
            self::VALUE_REQUEST_ID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
