<?php

namespace EnumType;

/**
 * This class stands for sbdUsageSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdUsageSearchTypeEnum
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'UPLOAD'
     * @return string 'UPLOAD'
     */
    const VALUE_UPLOAD = 'UPLOAD';
    /**
     * Constant for value 'NOTDELIVERED'
     * @return string 'NOTDELIVERED'
     */
    const VALUE_NOTDELIVERED = 'NOTDELIVERED';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'DOWNLOAD'
     * @return string 'DOWNLOAD'
     */
    const VALUE_DOWNLOAD = 'DOWNLOAD';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_UPLOAD
     * @uses self::VALUE_NOTDELIVERED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_DOWNLOAD
     * @uses self::VALUE_PENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_UPLOAD,
            self::VALUE_NOTDELIVERED,
            self::VALUE_ERROR,
            self::VALUE_DOWNLOAD,
            self::VALUE_PENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
