<?php

namespace EnumType;

/**
 * This class stands for sbdSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdSearchTypeEnum
{
    /**
     * Constant for value 'ACCOUNT_NUMBER'
     * @return string 'ACCOUNT_NUMBER'
     */
    const VALUE_ACCOUNT_NUMBER = 'ACCOUNT_NUMBER';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'IP'
     * @return string 'IP'
     */
    const VALUE_IP = 'IP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_IP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_IMEI,
            self::VALUE_IP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
