<?php

namespace EnumType;

/**
 * This class stands for roleTypeEnum EnumType
 * @subpackage Enumerations
 */
class RoleTypeEnum
{
    /**
     * Constant for value 'SPN_G_ADMIN'
     * @return string 'SPN_G_ADMIN'
     */
    const VALUE_SPN_G_ADMIN = 'SPN_G_ADMIN';
    /**
     * Constant for value 'SPN_G_CSR'
     * @return string 'SPN_G_CSR'
     */
    const VALUE_SPN_G_CSR = 'SPN_G_CSR';
    /**
     * Constant for value 'SPN_G_REPORT'
     * @return string 'SPN_G_REPORT'
     */
    const VALUE_SPN_G_REPORT = 'SPN_G_REPORT';
    /**
     * Constant for value 'SPN_SP_ADMIN'
     * @return string 'SPN_SP_ADMIN'
     */
    const VALUE_SPN_SP_ADMIN = 'SPN_SP_ADMIN';
    /**
     * Constant for value 'SPN_SP_CSR'
     * @return string 'SPN_SP_CSR'
     */
    const VALUE_SPN_SP_CSR = 'SPN_SP_CSR';
    /**
     * Constant for value 'SPN_SP_REPORT'
     * @return string 'SPN_SP_REPORT'
     */
    const VALUE_SPN_SP_REPORT = 'SPN_SP_REPORT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SPN_G_ADMIN
     * @uses self::VALUE_SPN_G_CSR
     * @uses self::VALUE_SPN_G_REPORT
     * @uses self::VALUE_SPN_SP_ADMIN
     * @uses self::VALUE_SPN_SP_CSR
     * @uses self::VALUE_SPN_SP_REPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SPN_G_ADMIN,
            self::VALUE_SPN_G_CSR,
            self::VALUE_SPN_G_REPORT,
            self::VALUE_SPN_SP_ADMIN,
            self::VALUE_SPN_SP_CSR,
            self::VALUE_SPN_SP_REPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
