<?php

namespace EnumType;

/**
 * This class stands for resourceInventoryTypeEnum EnumType
 * @subpackage Enumerations
 */
class ResourceInventoryTypeEnum
{
    /**
     * Constant for value 'CAPCODE'
     * @return string 'CAPCODE'
     */
    const VALUE_CAPCODE = 'CAPCODE';
    /**
     * Constant for value 'MSISDN'
     * @return string 'MSISDN'
     */
    const VALUE_MSISDN = 'MSISDN';
    /**
     * Constant for value 'MSISDNC'
     * @return string 'MSISDNC'
     */
    const VALUE_MSISDNC = 'MSISDNC';
    /**
     * Constant for value 'ICCID'
     * @return string 'ICCID'
     */
    const VALUE_ICCID = 'ICCID';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'IP'
     * @return string 'IP'
     */
    const VALUE_IP = 'IP';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'NUMBERS'
     * @return string 'NUMBERS'
     */
    const VALUE_NUMBERS = 'NUMBERS';
    /**
     * Constant for value 'LOCAL'
     * @return string 'LOCAL'
     */
    const VALUE_LOCAL = 'LOCAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAPCODE
     * @uses self::VALUE_MSISDN
     * @uses self::VALUE_MSISDNC
     * @uses self::VALUE_ICCID
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_IP
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_NUMBERS
     * @uses self::VALUE_LOCAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAPCODE,
            self::VALUE_MSISDN,
            self::VALUE_MSISDNC,
            self::VALUE_ICCID,
            self::VALUE_IMEI,
            self::VALUE_IP,
            self::VALUE_ISDNA,
            self::VALUE_NUMBERS,
            self::VALUE_LOCAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
