<?php

namespace EnumType;

/**
 * This class stands for purchaseConditionEnum EnumType
 * @subpackage Enumerations
 */
class PurchaseConditionEnum
{
    /**
     * Constant for value 'VOICE'
     * @return string 'VOICE'
     */
    const VALUE_VOICE = 'VOICE';
    /**
     * Constant for value 'STREAMING'
     * @return string 'STREAMING'
     */
    const VALUE_STREAMING = 'STREAMING';
    /**
     * Constant for value 'SBD'
     * @return string 'SBD'
     */
    const VALUE_SBD = 'SBD';
    /**
     * Constant for value 'PTT'
     * @return string 'PTT'
     */
    const VALUE_PTT = 'PTT';
    /**
     * Constant for value 'BURST'
     * @return string 'BURST'
     */
    const VALUE_BURST = 'BURST';
    /**
     * Constant for value 'SAFETY'
     * @return string 'SAFETY'
     */
    const VALUE_SAFETY = 'SAFETY';
    /**
     * Constant for value 'PUBLIC_IP'
     * @return string 'PUBLIC_IP'
     */
    const VALUE_PUBLIC_IP = 'PUBLIC_IP';
    /**
     * Constant for value 'LOCAL_NUMBER'
     * @return string 'LOCAL_NUMBER'
     */
    const VALUE_LOCAL_NUMBER = 'LOCAL_NUMBER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOICE
     * @uses self::VALUE_STREAMING
     * @uses self::VALUE_SBD
     * @uses self::VALUE_PTT
     * @uses self::VALUE_BURST
     * @uses self::VALUE_SAFETY
     * @uses self::VALUE_PUBLIC_IP
     * @uses self::VALUE_LOCAL_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICE,
            self::VALUE_STREAMING,
            self::VALUE_SBD,
            self::VALUE_PTT,
            self::VALUE_BURST,
            self::VALUE_SAFETY,
            self::VALUE_PUBLIC_IP,
            self::VALUE_LOCAL_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
